/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230.DeviceView;

import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm8230.DeviceView.Chassis;
import ibm.nways.jdm8230.DeviceView.Chassis8230_03;
import ibm.nways.jdm8230.DeviceView.Chassis8230_4A;
import ibm.nways.jdm8230.DeviceView.Chassis8230_4P;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.ChassisUnknown;
import ibm.nways.jdm8230.DeviceView.FactoryLike;
import ibm.nways.jdm8230.DeviceView.ModuleICS;
import ibm.nways.jdm8230.DeviceView.ModuleLAM_ICS;
import ibm.nways.jdm8230.DeviceView.ModuleLAM_RJ45;
import ibm.nways.jdm8230.DeviceView.ModuleLike;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_Fiber;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_FiberICS;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_ICS;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_ICSFiber;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_Model4;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_RJ45;
import ibm.nways.jdm8230.DeviceView.ModuleRI_RO_Unknown;
import ibm.nways.jdm8230.DeviceView.ModuleRLIU;
import ibm.nways.jdm8230.DeviceView.ModuleUnknown;
import ibm.nways.jdm8230.DeviceView.ModuleUtp_Active;
import ibm.nways.jdm8230.DeviceView.ModuleUtp_Active_Model4;
import ibm.nways.jdm8230.DeviceView.ModuleUtp_Passive;
import ibm.nways.jdm8230.DeviceView.ModuleUtp_Passive_Model4;
import ibm.nways.jdm8230.DeviceView.PortFiber;
import ibm.nways.jdm8230.DeviceView.PortICS;
import ibm.nways.jdm8230.DeviceView.PortLike;
import ibm.nways.jdm8230.DeviceView.PortRI_ROFiber;
import ibm.nways.jdm8230.DeviceView.PortRI_ROICS;
import ibm.nways.jdm8230.DeviceView.PortRI_ROLike;
import ibm.nways.jdm8230.DeviceView.PortRI_RORJ45;
import ibm.nways.jdm8230.DeviceView.PortRI_ROUnknown;
import ibm.nways.jdm8230.DeviceView.PortRJ45;
import ibm.nways.jdm8230.DeviceView.PortRJ45_LAM;
import ibm.nways.jdm8230.DeviceView.PortUnknown;
import ibm.nways.jdm8230.DeviceView.RLamActive;
import ibm.nways.jdm8230.DeviceView.RLamNotDetected;
import ibm.nways.jdm8230.DeviceView.RLamPassive;
import ibm.nways.jdm8230.DeviceView.RLamUnknown;
import ibm.nways.jdm8230.DeviceView.RLiuControlPort;
import ibm.nways.jdm8230.DeviceView.RLiuDataPort;
import ibm.nways.jdm8230.DeviceView.RLiuPortLike;
import ibm.nways.jdm8230.DeviceView.SpeedSwitch16;
import ibm.nways.jdm8230.DeviceView.SpeedSwitch16_Model4;
import ibm.nways.jdm8230.DeviceView.SpeedSwitch4;
import ibm.nways.jdm8230.DeviceView.SpeedSwitch4_Model4;
import ibm.nways.jdm8230.DeviceView.SpeedSwitchLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class Factory
implements FactoryLike {
    private static final Factory factoryInstance = new Factory();

    private Factory() {
    }

    public static FactoryLike getInstance() {
        return factoryInstance;
    }

    public ChassisLike createChassis(Serializable serializable, Serializable serializable2) {
        Chassis chassis = null;
        if (serializable instanceof SpecialValue || serializable2 instanceof SpecialValue) {
            RAS.logError(19, 4, this, "createChassis", "Unknown sysObjectID -> " + serializable);
            return new ChassisUnknown();
        }
        String string = serializable.toString();
        if (!string.equals("1.3.6.1.4.1.2.6.15")) {
            RAS.logError(19, 4, this, "createChassis", "Unknown sysObjectID 2 -> " + serializable);
            return new ChassisUnknown();
        }
        int n = Chassis.modelFromCauType(serializable2.toString());
        if (n == -1) {
            RAS.logError(19, 4, this, "createChassis", "Unknown sysObjectID 3 -> " + serializable);
            return new ChassisUnknown();
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                chassis = new Chassis8230_03();
                break;
            }
            case 3: {
                chassis = new Chassis8230_4A();
                break;
            }
            case 4: {
                chassis = new Chassis8230_4P();
                break;
            }
            default: {
                RAS.logError(19, 4, this, "createChassis", "Unknown sysObjectID 4 -> " + serializable);
                chassis = new ChassisUnknown();
            }
        }
        chassis.setChassisModel(n);
        return chassis;
    }

    public ModuleLike createModule(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                switch (n2) {
                    case 3: {
                        return new ModuleLAM_ICS();
                    }
                    case 4: {
                        return new ModuleLAM_RJ45();
                    }
                }
            }
            case 2: {
                return new ModuleICS();
            }
            case 3: {
                if (n3 == 3 || n3 == 4) {
                    return new ModuleUtp_Active_Model4();
                }
                return new ModuleUtp_Active();
            }
            case 4: {
                if (n3 == 3 || n3 == 4) {
                    return new ModuleUtp_Passive_Model4();
                }
                return new ModuleUtp_Passive();
            }
            case 6: {
                return new ModuleRLIU();
            }
        }
        return new ModuleUnknown();
    }

    public ModuleLike createRIRO(int n, int n2, int n3, int n4) {
        if (n4 == 3 || n4 == 4) {
            return new ModuleRI_RO_Model4();
        }
        if (n2 != n3) {
            if (n2 == 2 && n3 == 3) {
                return new ModuleRI_RO_FiberICS();
            }
            if (n2 == 3 && n3 == 2) {
                return new ModuleRI_RO_ICSFiber();
            }
            n3 = n2;
            if (RAS.isEnabled(19, 4)) {
                RAS.trace(19, 4, this, "createRIRO", "RI/RO media type isn't supported by application.");
            }
        }
        if (n2 == n3) {
            switch (n2) {
                case 3: {
                    return new ModuleRI_RO_ICS();
                }
                case 4: {
                    return new ModuleRI_RO_RJ45();
                }
                case 2: {
                    return new ModuleRI_RO_Fiber();
                }
            }
            return new ModuleRI_RO_Unknown();
        }
        return null;
    }

    public ModuleLike createRLam(int n) {
        switch (n) {
            case 1: {
                return new RLamUnknown();
            }
            case 2: {
                return new RLamNotDetected();
            }
            case 3: {
                return new RLamPassive();
            }
            case 4: {
                return new RLamActive();
            }
        }
        return new RLamUnknown();
    }

    public PortLike createPort(int n, int n2, String string) {
        switch (n) {
            case 1: {
                return new PortUnknown();
            }
            case 2: {
                return new PortFiber();
            }
            case 3: {
                return new PortICS(n2, string);
            }
            case 4: {
                return new PortRJ45(n2, string);
            }
            case 5: {
                return new PortRJ45_LAM(n2, string);
            }
        }
        return new PortUnknown();
    }

    public PortRI_ROLike createRI_ROPort(int n, int n2, String string) {
        switch (n) {
            case 1: {
                return new PortRI_ROUnknown();
            }
            case 2: {
                return new PortRI_ROFiber(n2, string);
            }
            case 3: {
                return new PortRI_ROICS(n2, string);
            }
            case 4: {
                return new PortRI_RORJ45(n2, string);
            }
        }
        return new PortRI_ROUnknown();
    }

    public RLiuPortLike createRLiuPort(int n) {
        switch (n) {
            case 1: {
                return new RLiuControlPort();
            }
            case 2: {
                return new RLiuDataPort();
            }
        }
        return null;
    }

    public SpeedSwitchLike createSpeedSwitch(int n, int n2) {
        if (n2 == 3 || n2 == 4) {
            switch (n) {
                case 4000000: {
                    return new SpeedSwitch4_Model4();
                }
                case 16000000: {
                    return new SpeedSwitch16_Model4();
                }
            }
            return new SpeedSwitch4_Model4();
        }
        switch (n) {
            case 4000000: {
                return new SpeedSwitch4();
            }
            case 16000000: {
                return new SpeedSwitch16();
            }
        }
        return new SpeedSwitch4();
    }
}

